package gov.va.genisis2.exceptions;

public class GenisisException extends Exception {
	/**
	 * 
	 */
	private static final long serialVersionUID = -9178607123643430857L;
	/** The error message. */
	private final String message;
	/** The throwable. */
	private final Throwable throwable;

	/**
	 * @param message The error message
	 * @param throwable The throwable exception
	 */
	public GenisisException(String message, Throwable throwable) {
		super(message, throwable);
		this.message = message;
		this.throwable = throwable;
	}

	/**
	 * @return the message
	 */
	@Override
	public String getMessage() {
		return message;
	}

	/**
	 * @return the throwable
	 */
	public Throwable getThrowable() {
		return throwable;
	}
}
